<!DOCTYPE html>
<?php
    $site_direction = session()->get('site_direction');
?>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($site_direction); ?>">

<head>
    <!-- Google Tag Manager -->
    <script>
        (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-59S4M2GL');
    </script>
    <!-- End Google Tag Manager -->

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta name="description" content=""/>
    <meta name="keywords" content=""/>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php ($favIcon = getBusinessSettingsImageFullPath(key: 'business_favicon', settingType: 'business_information', path: 'business/',  defaultPath : 'public/assets/placeholder.png')); ?>
    <link rel="shortcut icon" href="<?php echo e($favIcon); ?>"/>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,400&display=swap"
        rel="stylesheet">


    <link href="<?php echo e(asset('public/assets/admin-module')); ?>/css/material-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/admin-module')); ?>/css/bootstrap.min.css"/>
    <link rel="stylesheet"
          href="<?php echo e(asset('public/assets/admin-module')); ?>/plugins/perfect-scrollbar/perfect-scrollbar.min.css"/>


    <link rel="stylesheet" href="<?php echo e(asset('public/assets/admin-module')); ?>/plugins/apex/apexcharts.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/admin-module')); ?>/plugins/select2/select2.min.css"/>

    <link rel="stylesheet" href="<?php echo e(asset('public/assets/admin-module')); ?>/css/toastr.css">

    <link rel="stylesheet" href="<?php echo e(asset('public/assets/admin-module/plugins/intl-tel-input/css/intlTelInput.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('public/assets/admin-module')); ?>/css/style.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/admin-module')); ?>/css/dev.css"/>
    <?php if(env('APP_ENV') == 'demo'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('public/assets')); ?>/css/demo.css"/>
    <?php endif; ?>

    <?php echo $__env->yieldPushContent('css_or_js'); ?>
</head>

<body id="<?php echo e(env('APP_ENV') == 'demo' ? 'demo' : ''); ?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-59S4M2GL"
                  height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

<script>
    localStorage.theme && document.querySelector('body').setAttribute("theme", localStorage.theme);
</script>

<div class="offcanvas-overlay"></div>


<div class="preloader"></div>


<?php echo $__env->make('adminmodule::layouts.partials._header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->make('adminmodule::layouts.partials._aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->make('adminmodule::layouts.partials._settings-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<main class="main-area demo-main-area">
    <?php echo $__env->yieldContent('content'); ?>


    <?php echo $__env->make('adminmodule::layouts.partials._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if(env('APP_ENV') == 'demo'): ?>
        <div class="alert alert--message-2 alert-dismissible fade show" id="demo-reset-warning">
            <img width="28" class="align-self-start" src="<?php echo e(asset('public/assets/admin-module/img/info-2.png')); ?>" alt="">
            <div class="w-0 flex-grow-1">
                <h6><?php echo e(translate('warning').'!'); ?></h6>
                <span class="warning-message">
            <?php echo e(translate('though_it_is_a_demo_site').'.'.translate('_our_system_automatically_reset_after_one_hour_&_that_is_why_you_logged_out').'.'); ?>

        </span>
            </div>
            <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
</main>


<script src="<?php echo e(asset('public/assets/admin-module')); ?>/js/jquery-3.6.0.min.js"></script>
<script src="<?php echo e(asset('public/assets/admin-module')); ?>/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo e(asset('public/assets/admin-module')); ?>/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="<?php echo e(asset('public/assets/admin-module')); ?>/js/main.js"></script>
<script src="<?php echo e(asset('public/assets/admin-module')); ?>/js/helper.js"></script>

<script src="<?php echo e(asset('public/assets/admin-module')); ?>/plugins/select2/select2.min.js"></script>


<script src="<?php echo e(asset('public/assets/admin-module')); ?>/js/sweet_alert.js"></script>
<script src="<?php echo e(asset('public/assets/admin-module')); ?>/js/toastr.js"></script>
<script src="<?php echo e(asset('public/assets/admin-module')); ?>/js/dev.js"></script>
<?php if(env('APP_ENV') == 'demo'): ?>
    <script src="<?php echo e(asset('public/assets')); ?>/js/demo.js"></script>
<?php endif; ?>
<script src="<?php echo e(asset('public/assets/admin-module/plugins/intl-tel-input/js/intlTelInput.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/admin-module/js/country-picker-init.js')); ?>"></script>
<?php echo Toastr::message(); ?>


<audio id="audio-element">
    <source src="<?php echo e(asset('public/assets/provider-module')); ?>/sound/notification.mp3" type="audio/mpeg">
</audio>

<script>
    "use strict";
    $(document).ready(function () {
        $('.js-select').select2();
    });

    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        toastr.error('<?php echo e($error); ?>', Error, {
            CloseButton: true,
            ProgressBar: true
        });
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
   <?php endif; ?>

    function checkDemoResetTime() {
        let currentMinute = new Date().getMinutes();
        if (currentMinute > 55 && currentMinute <= 60) {
            $('#demo-reset-warning').addClass('active');
        } else {
            $('#demo-reset-warning').removeClass('active');
        }
    }
    checkDemoResetTime();
    setInterval(checkDemoResetTime, 60000);

    $('.form-alert').on('click', function (){
        let id = $(this).data('id');
        let message = $(this).data('message');
        form_alert(id, message)
    });

    function form_alert(id, message) {
        Swal.fire({
            title: "<?php echo e(translate('are_you_sure')); ?>?",
            text: message,
            type: 'warning',
            showCloseButton: true,
            showCancelButton: true,
            cancelButtonColor: 'var(--c2)',
            confirmButtonColor: 'var(--c1)',
            cancelButtonText: 'Cancel',
            confirmButtonText: 'Yes',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $('#' + id).submit()
            }
        })
    }

    $('.route-alert').on('click', function (){
        let route = $(this).data('route');
        let message = $(this).data('message');
        route_alert(route, message)
    });

    function route_alert(route, message) {
        Swal.fire({
            title: "<?php echo e(translate('are_you_sure')); ?>?",
            text: message,
            type: 'warning',
            showCancelButton: true,
            cancelButtonColor: 'var(--c2)',
            confirmButtonColor: 'var(--c1)',
            cancelButtonText: 'Cancel',
            confirmButtonText: 'Yes',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.get({
                    url: route,
                    dataType: 'json',
                    data: {},
                    beforeSend: function () {

                    },
                    success: function (data) {
                        toastr.success(data.message, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    },
                    complete: function () {

                    },
                });
            }
        })
    }

    $('.route-alert-reload').on('click', function (){
        let route = $(this).data('route');
        let message = $(this).data('message');
        route_alert_reload(route, message, true);
    });

    function route_alert_reload(route, message, reload, status = null, id = null) {
        Swal.fire({
            title: "<?php echo e(translate('are_you_sure')); ?>?",
            text: message,
            type: 'warning',
            showCancelButton: true,
            cancelButtonColor: 'var(--c2)',
            confirmButtonColor: 'var(--c1)',
            cancelButtonText: 'Cancel',
            confirmButtonText: 'Yes',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.get({
                    url: route,
                    dataType: 'json',
                    data: {},
                    beforeSend: function () {

                    },
                    success: function (data) {
                        if (reload) {
                            setTimeout(location.reload.bind(location), 1000);
                        }
                        toastr.success(data.message, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    },
                    complete: function () {

                    },
                });
            }else {
                if (status === 1) $(`#${id}`).prop('checked', false);
                if (status === 0) $(`#${id}`).prop('checked', true);
            }
        })
    }

    var audio = document.getElementById("audio-element");

    function playAudio(status) {
        status ? audio.play() : audio.pause();
    }

    setInterval(function () {
        $.get({
            url: '<?php echo e(route('admin.get_updated_data')); ?>',
            dataType: 'json',
            success: function (response) {
                let data = response.data;
                document.getElementById("message_count").innerHTML = data.message;
            },
        });
    }, 10000);


    $("#search-form__input").on("keyup", function () {
        var value = this.value.toLowerCase().trim();
        $(".show-search-result a").show().filter(function () {
            return $(this).text().toLowerCase().trim().indexOf(value) == -1;
        }).hide();
    });

    function demo_mode() {
        toastr.info('This function is disable for demo mode', {
            CloseButton: true,
            ProgressBar: true
        });
    }

    $('.demo_check').on('click', function (event) {
        if ('<?php echo e(env('APP_ENV')=='demo'); ?>') {
            event.preventDefault();
            demo_mode()
        }
    });

    $('.admin-logout').on('click', function (event) {
        Swal.fire({
            title: "<?php echo e(translate('are_you_sure')); ?>?",
            text: "<?php echo e(translate('want_to_logout')); ?>",
            type: 'warning',
            showCloseButton: true,
            showCancelButton: true,
            cancelButtonColor: 'var(--c2)',
            confirmButtonColor: 'var(--c1)',
            cancelButtonText: 'Cancel',
            confirmButtonText: 'Yes',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                location.href = "<?php echo e(route('admin.auth.logout')); ?>"
            }
        })
    });

    $(document).ready(function () {
        $('#searchForm input[name="search"]').keyup(function () {
            var searchKeyword = $(this).val().trim();

            if (searchKeyword.length >= 2) {
                $.ajax({
                    type: 'POST',
                    url: $('#searchForm').attr('action'),
                    data: {search: searchKeyword, _token: $('input[name="_token"]').val()},
                    success: function (response) {
                        if (response.length === 0) {
                            $('#searchResults').html('<div class="text-center text-muted py-5"><?php echo e(translate('No results found')); ?></div>');
                        } else {
                            var resultHtml = '';
                            response.forEach(function (route) {
                                resultHtml += '<a href="' + route.fullRoute + '" class="search-list-item d-flex flex-column" aria-current="true">';
                                resultHtml += '<h5>' + route.routeName + '</h5>';
                                resultHtml += '<p class="text-muted fs-12">' + route.URI + '</p>';
                                resultHtml += '</a>';
                            });
                            $('#searchResults').html('<div class="search-list d-flex flex-column">' + resultHtml + '</div>');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            } else {
                $('#searchResults').html('<div class="text-center text-muted py-5"><?php echo e(translate('Write a minimum of two characters.')); ?></div>');
            }
        });
    });

    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && event.key === 'k') {
            event.preventDefault();
            document.getElementById('modalOpener').click();
        }
    });

    $('#searchForm').submit(function (event) {
        event.preventDefault();
    });

    $(document).ready(function(){
        $('.admin-renew-package').on('click', function() {
            var packageId = $(this).data('id');
            var providerId = $(this).data('provider');

            $.ajax({
                url: '<?php echo e(route("admin.provider.subscription-package.renew.ajax")); ?>',
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: packageId,
                    providerId: providerId
                },
                success: function(response) {
                    $('.admin-append-renew').html(response);
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                }
            });
        });
    });

    $(document).ready(function(){
        $('.admin-shift-package').on('click', function() {
            var packageId = $(this).data('id');
            var providerId = $(this).data('provider');

            $.ajax({
                url: '<?php echo e(route("admin.provider.subscription-package.shift.ajax")); ?>',
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: packageId,
                    providerId: providerId
                },
                success: function(response) {
                    $('.admin-append-shift').html(response);
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                }
            });
        });
    });

    $(document).ready(function(){
        $('.admin-purchase-package').on('click', function() {
            var packageId = $(this).data('id');
            var providerId = $(this).data('provider');

            $.ajax({
                url: '<?php echo e(route("admin.provider.subscription-package.purchase.ajax")); ?>',
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: packageId,
                    providerId: providerId
                },
                success: function(response) {
                    $('.admin-append-purchase').html(response);
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                }
            });
        });
    });

</script>

<script>
   <?php if(!request()->is('admin/business-setting*') && request()->is('admin/service*')): ?>
       document.addEventListener('DOMContentLoaded', function () {
           replaceEmailsAndPhoneNumbersWithAsterisks(document.getElementById('demo'));

           document.querySelectorAll('a[href^="mailto:"]').forEach(function(link) {
               link.addEventListener('click', function(event) {
                   event.preventDefault();
               });
           });
           document.querySelectorAll('a[href^="tel:"]').forEach(function(link) {
               link.addEventListener('click', function(event) {
                   event.preventDefault();
               });
           });
       });

       function replaceEmailsAndPhoneNumbersWithAsterisks(element) {
       if (element.nodeType === 3) { // Text node
           // Use regular expressions to match email and phone number patterns
           element.nodeValue = element.nodeValue
               .replace(/\b([A-Za-z0-9._%+-])[^@]*@([A-Za-z0-9.-]+)\.([A-Z|a-z]{2,})\b/g, function (match, firstLetter, domain, tld) {
                   var remainingAsterisks = '*'.repeat(Math.min(10, match.length - 1));
                   return firstLetter + remainingAsterisks + '@' + domain + '.' + tld;
               })
               .replace(/\b(?:\+\d{1,3}\s?)?\d{1,4}[-.\s]?\d{5,}\b/g, function (match) {
                   if (match.length >= 10) {
                       var firstChar = match.charAt(0) === '+' ? '+' : match.charAt(0);
                       var remainingAsterisks = '*'.repeat(Math.min(10, match.length - (firstChar === '+' ? 2 : 1)));
                       return firstChar + remainingAsterisks;
                   } else {
                       return match;  // Don't replace if the length is less than 10
                   }
               });
       } else if (element.nodeType === 1) { // Element node
           for (var i = 0; i < element.childNodes.length; i++) {
               replaceEmailsAndPhoneNumbersWithAsterisks(element.childNodes[i]);
           }
       }
   }
   <?php endif; ?>
</script>

<?php echo $__env->yieldPushContent('script'); ?>
</body>

</html>
<?php /**PATH /opt/lampp/htdocs/Demandium-Admin/Modules/AdminModule/Resources/views/layouts/master.blade.php ENDPATH**/ ?>