<!DOCTYPE html>
<?php
    $site_direction = session()->get('landing_site_direction');
?>
<html lang="en" dir="<?php echo e($site_direction); ?>">

<head>

    <!-- Google Tag Manager -->
    <script>
        (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-59S4M2GL');
    </script>
    <!-- End Google Tag Manager -->

    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta name="robots" content="nofollow, noindex, max-snippet:1, max-video-preview:1, max-image-preview:standard">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <meta property="og:image"
          content="<?php echo e(asset('storage/app/public/landing-page/meta')); ?>/<?php echo e(bs_data($settings,'meta_image', 1,true)); ?>"/>
    <meta property="og:title" content="<?php echo e(bs_data($settings,'meta_title', 1,true)); ?>"/>
    <meta property="og:description" content="<?php echo e(bs_data($settings,'meta_description', 1,true)); ?>">

    <link href="<?php echo e(asset('public/assets/provider-module')); ?>/css/material-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/landing')); ?>/css/bootstrap.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/landing')); ?>/css/line-awesome.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/landing')); ?>/css/owl.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/landing')); ?>/css/swiper-bundle.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/landing')); ?>/css/main.css"/>
    <?php if(env('APP_ENV') == 'demo'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('public/assets')); ?>/css/demo.css"/>
    <?php endif; ?>

    <link rel="shortcut icon"
          href="<?php echo e(asset('storage/app/public/business')); ?>/<?php echo e(bs_data($settings,'business_favicon', 1)); ?>"
          type="image/x-icon"/>

    <style>
        :root {
            --body-bg: <?php echo e(bs_data($settings,'body_background', 1,true)); ?>;
            --header-bg: <?php echo e(bs_data($settings,'header_background', 1,true)); ?>;
            --footer: <?php echo e(bs_data($settings,'footer_background', 1,true)); ?>;
            --footer-bottom: <?php echo e(bs_data($settings,'header_background', 1,true)); ?>;
        }

        .dark-theme {
            --body-bg: #121213;
            --header-bg: #11202be6;
            --footer: #001f35;
            --footer-bottom: #111a21;
        }
    </style>
</head>

<body class="<?php echo e(env('APP_ENV')=='demo'?'demo':''); ?>">

<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-59S4M2GL"
                  height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<?php if(env('APP_ENV') == 'demo'): ?>
    <div class="__announcement-bar" style="background-image: url(<?php echo e(asset('public/assets/img/demo/website-top-header.png')); ?>)">
        <div class="container">
            <div class="wrapper">
                <div class="txt">
                    <?php echo e(translate('Buy genuine Demandium from official link with 50% OFF!')); ?>

                </div>
                <a href="https://codecanyon.net/item/demandium-multi-provider-on-demand-handyman-home-service-app-with-admin-panel/40224772?gad_source=1&gclid=CjwKCAjw5v2wBhBrEiwAXDDoJck6rCTmDfWqTXdESbfVnwWE6-tdKKmWecB35zo4af3VMloR9uoSKBoC4cMQAvD_BwE" class="click" target="_blank">Offer Ending Soon <img src="<?php echo e(asset('public/assets/arrowww.png')); ?>" alt=""></a>
                <a href="https://codecanyon.net/item/demandium-multi-provider-on-demand-handyman-home-service-app-with-admin-panel/40224772?gad_source=1&gclid=CjwKCAjw5v2wBhBrEiwAXDDoJck6rCTmDfWqTXdESbfVnwWE6-tdKKmWecB35zo4af3VMloR9uoSKBoC4cMQAvD_BwE" class="btn btn-sm" style="background-color: #FF7500; color:#ffffff" target="_blank">Buy Now</a>
            </div>
        </div>
    </div>
<?php endif; ?>
<div id="landing-loader"></div>
<div class="navbar-top">
    <div class="container">
        <div class="navbar-top-wrapper">
            <div class="mode--toggle">
                <img src="" alt="">
            </div>
            <div class="hs-unfold top-padding">
                <div>
                    <?php ( $local = session()->has('landing_local')?session('landing_local'):'en'); ?>
                    <?php ($siteDirection = session()->has('landing_site_direction')?session('landing_site_direction'):'ltr'); ?>
                    <?php ($lang = Modules\BusinessSettingsModule\Entities\BusinessSettings::where('key_name','system_language')->first()); ?>
                    <?php if($lang): ?>
                        <div class="topbar-text dropdown d-flex">
                            <a class="topbar-link dropdown-toggle d-flex align-items-center title-color gap-1 lagn-drop-btn justify-content-between align-items-center"
                               href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <?php $__currentLoopData = $lang['live_values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($data['code']==$local): ?>
                                        <?php ($language = collect(LANGUAGES)->where('code', $data['code'])->first()); ?>
                                        <?php if($language): ?>
                                            <span class="d-flex align-items-center gap-2">
                                                <span class="material-icons">language</span>
                                                <?php echo e($language['nativeName']); ?>

                                                <span class="fz-10">(<?php echo e($data['code']); ?>)</span>
                                            </span>
                                        <?php else: ?>
                                            <?php echo e($data['code']); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </a>
                            <ul class="dropdown-menu lang-menu">
                                <?php $__currentLoopData = $lang['live_values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($data['status']==1): ?>
                                        <?php ($language = collect(LANGUAGES)->where('code', $data['code'])->first()); ?>
                                        <li>
                                            <a class="dropdown-item d-flex gap-2 align-items-center py-2 justify-content-between"
                                               href="<?php echo e(route('lang',[$data['code']])); ?>">
                                               <div class="d-flex gap-2 align-items-center">
                                                <?php if($language): ?>
                                                    <span class="text-capitalize">
                                                        <?php echo e($language['nativeName']); ?>

                                                        <span class="fz-10">(<?php echo e($data['code']); ?>)</span>
                                                    </span>

                                                    <?php else: ?>
                                                        <span class="text-capitalize"><?php echo e($data['code']); ?></span>
                                                    <?php endif; ?>
                                               </div>
                                               <span class="material-symbols-outlined text-muted">check_circle</span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
            <div class="top-padding">
                <a href="tel:<?php echo e(bs_data($settings,'business_phone', 1)); ?>"
                   class="tel-link text--base">
                    <i class="las la-phone"></i>
                    <?php echo e(bs_data($settings,'business_phone', 1)); ?>

                </a>
            </div>
        </div>
    </div>
</div>
<header>
    <?php ($logo = getBusinessSettingsImageFullPath(key: 'business_logo', settingType: 'business_information', path: 'business/', defaultPath: 'public/assets/placeholder.png')); ?>

    <div class="navbar-bottom">
        <div class="container">
            <div class="navbar-bottom-wrapper">
                <a href="<?php echo e(route('home')); ?>" class="logo">
                    <img alt="<?php echo e(translate('business logo')); ?>" src="<?php echo e($logo); ?>">
                </a>
                <ul class="menu me-lg-4">
                    <li>
                        <a href="<?php echo e(route('home')); ?>"
                           class="<?php echo e(request()->is('/')?'active':''); ?>"><span><?php echo e(translate('home')); ?></span></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('home')); ?>#service"><span><?php echo e(translate('our_service')); ?></span></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('page.about-us')); ?>" class="<?php echo e(request()->is('page/about-us')?'active':''); ?>">
                            <span><?php echo e(translate('about_us')); ?></span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('page.privacy-policy')); ?>"
                           class="<?php echo e(request()->is('page/privacy-policy')?'active':''); ?>">
                            <span><?php echo e(translate('privacy_policy')); ?></span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('page.terms-and-conditions')); ?>" class="<?php echo e(request()->is('page/terms-and-conditions')?'active':''); ?>">
                            <span><?php echo e(translate('terms_&_conditions')); ?></span>
                        </a>
                    </li>
                </ul>
                <div class="nav-toggle d-lg-none ms-auto me-2 me-sm-4">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <a href="<?php echo e(route('page.contact-us')); ?>" class="cmn--btn"><?php echo e(translate('contact_us')); ?></a>
            </div>
        </div>
    </div>
</header>

<?php echo $__env->yieldContent('content'); ?>

<footer>
    <div class="footer-top">
        <div class="container">
            <div class="footer__wrapper">
                <div class="footer__wrapper-widget">
                    <div class="cont">
                        <a href="#" class="logo mb-4">
                            <img src="<?php echo e($logo); ?>" alt="<?php echo e(translate('logo')); ?>">
                        </a>
                        <p class="mb-4"><?php echo e(translate('Connect with our social media and other sites to keep up to date')); ?></p>
                        <div class="app-btns">
                            <?php if($settings->where('key_name','app_url_appstore')->first()->is_active??0): ?>
                                <a href="<?php echo e(bs_data($settings,'app_url_appstore', 1)); ?>" class="d-block">
                                    <img class="w-100" src="<?php echo e(asset('public/assets/landing/img/app-btn/app-store.png')); ?>" alt="<?php echo e(translate('app store')); ?>">
                                </a>
                            <?php endif; ?>

                            <?php if($settings->where('key_name','app_url_playstore')->first()->is_active??0): ?>
                                <a href="<?php echo e(bs_data($settings,'app_url_playstore', 1)); ?>" class="d-block">
                                    <img class="w-100" src="<?php echo e(asset('public/assets/landing/img/app-btn/google-play.png')); ?>" alt="<?php echo e(translate('play store')); ?>">
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="footer__wrapper-widget">
                    <ul class="footer__wrapper-link">
                        <li>
                            <a href="<?php echo e(route('home')); ?>"><?php echo e(translate('home')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('page.about-us')); ?>"><?php echo e(translate('about_us')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('page.contact-us')); ?>"><?php echo e(translate('contact_us')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('page.privacy-policy')); ?>"><?php echo e(translate('privacy_policy')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('page.terms-and-conditions')); ?>"><?php echo e(translate('terms_&_conditions')); ?></a>
                        </li>
                        <?php if(\Modules\BusinessSettingsModule\Entities\DataSetting::where('key', 'cancellation_policy')->first()->is_active == '1'): ?>
                            <li>
                                <a href="<?php echo e(route('page.cancellation-policy')); ?>"><?php echo e(translate('cancellation_policy')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(\Modules\BusinessSettingsModule\Entities\DataSetting::where('key', 'refund_policy')->first()->is_active == '1'): ?>
                            <li>
                                <a href="<?php echo e(route('page.refund-policy')); ?>"><?php echo e(translate('refund_policy')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="footer__wrapper-widget">
                    <div class="footer__wrapper-contact">
                        <img class="icon" src="<?php echo e(asset('public/assets/landing/img/footer/mail.png')); ?>" alt="<?php echo e(translate('footer')); ?>">
                        <h6>
                            <?php echo e(translate('send_us_mail')); ?>

                        </h6>
                        <a href="Mailto:<?php echo e(bs_data($settings,'business_email', 1)); ?>"><?php echo e(bs_data($settings,'business_email', 1)); ?></a>
                    </div>
                </div>
                <div class="footer__wrapper-widget">
                    <div class="footer__wrapper-contact">
                        <img class="icon" src="<?php echo e(asset('public/assets/landing/img/footer/tel.png')); ?>" alt="<?php echo e(translate('footer')); ?>">
                        <h6>
                            <?php echo e(translate('contact_us')); ?>

                        </h6>
                        <a href="Tel:<?php echo e(bs_data($settings,'business_phone', 1)); ?>"><?php echo e(bs_data($settings,'business_phone', 1)); ?></a>
                    </div>
                </div>
                <div class="footer__wrapper-widget">
                    <div class="footer__wrapper-contact">
                        <img class="icon" src="<?php echo e(asset('public/assets/landing/img/footer/pin.png')); ?>" alt="<?php echo e(translate('footer')); ?>">
                        <h6>
                            <?php echo e(translate('find_us_here')); ?>

                        </h6>
                        <div><span><?php echo e(bs_data($settings,'business_address', 1)); ?></span></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom text-center py-3">
        <?php echo e(bs_data($settings,'footer_text', 1)); ?>

    </div>
</footer>

<script src="<?php echo e(asset('public/assets/landing')); ?>/js/jquery-3.6.0.min.js"></script>
<script src="<?php echo e(asset('public/assets/landing')); ?>/js/viewport.jquery.js"></script>
<script src="<?php echo e(asset('public/assets/landing')); ?>/js/wow.min.js"></script>
<script src="<?php echo e(asset('public/assets/landing')); ?>/js/owl.min.js"></script>
<script src="<?php echo e(asset('public/assets/landing')); ?>/js/swiper-bundle.min.js"></script>
<script src="<?php echo e(asset('public/assets/landing')); ?>/js/bootstrap.min.js"></script>
<script src="<?php echo e(asset('public/assets/landing')); ?>/js/custom.js"></script>
<?php if(env('APP_ENV') == 'demo'): ?>
    <script src="<?php echo e(asset('public/assets')); ?>/js/demo.js"></script>
<?php endif; ?>

<script>
    "use strict";

    (function ($) {
        $(document).ready(function () {
            $(".accordion-title").on("click", function (e) {
                var element = $(this).parent(".accordion-item");
                if (element.hasClass("open")) {
                    element.removeClass("open");
                    element.find(".accordion-content").removeClass("open");
                    element.find(".accordion-content").slideUp(200, "swing");
                } else {
                    element.addClass("open");
                    element.children(".accordion-content").slideDown(200, "swing");
                    element
                        .siblings(".accordion-item")
                        .children(".accordion-content")
                        .slideUp(200, "swing");
                    element.siblings(".accordion-item").removeClass("open");
                    element
                        .siblings(".accordion-item")
                        .find(".accordion-title")
                        .removeClass("open");
                    element
                        .siblings(".accordion-item")
                        .find(".accordion-content")
                        .slideUp(200, "swing");
                }
            });

            let fixed_top = $(".navbar-bottom");
            $(window).on("scroll", function () {
                if ($(this).scrollTop() > 110) {
                    fixed_top.addClass("active");
                } else {
                    fixed_top.removeClass("active");
                }
            });

            $(".owl-prev").html('<i class="fas fa-angle-left">');
            $(".owl-next").html('<i class="fas fa-angle-right">');

            if ($(".wow").length) {
                var wow = new WOW({
                    boxClass: "wow",
                    animateClass: "animated",
                    offset: 0,
                    mobile: true,
                    live: true,
                });
                wow.init();
            }

            $(".mode--toggle").on("click", function () {
                setTheme(localStorage.getItem("theme"));
            });
            if (localStorage.getItem("theme") == "light-theme") {
                localStorage.setItem("theme", "dark-theme");
            } else {
                localStorage.setItem("theme", "light-theme");
            }
            setTheme(localStorage.getItem("theme"));

            function setTheme(theme) {
                if (theme == "dark-theme") {
                    localStorage.setItem("theme", "light-theme");
                    $("html").addClass(theme);
                    $(".mode--toggle").find("img").attr("src", "<?php echo e(asset('public/assets/landing')); ?>/img/moon.png");
                } else {
                    localStorage.setItem("theme", "dark-theme");
                    $("html").removeClass("dark-theme");
                    $(".mode--toggle").find("img").attr("src", "<?php echo e(asset('public/assets/landing')); ?>/img/sun.png");
                }
            }

            $(".nav-toggle").on("click", () => {
                $(".nav-toggle").toggleClass("active");
                $(".menu").toggleClass("active");
                $(".navbar-bottom-wrapper").toggleClass("rounded-0");
            });

            let siteDirection = "<?php echo e($siteDirection); ?>";
            siteDirection = siteDirection === 'rtl';

            // ---- testimonial swiper slider
            var originalSlides = document.querySelectorAll('.testimonial__item').length;
            var swiper = new Swiper(".testimonial-slider", {
                effect: "coverflow",
                grabCursor: true,
                centeredSlides: true,
                coverflowEffect: {
                    rotate: 0,
                    stretch: 0,
                    depth: 100,
                    modifier: 2.5,
                    slideShadows: false
                },
                autoplay: {
                    delay: 1500,
                    disableOnInteraction: false
                },
                keyboard: {
                    enabled: true
                },
                mousewheel: {
                    thresholdDelta: 70
                },
                spaceBetween: 30,
                loop: true,
                breakpoints: {
                    640: {
                        slidesPerView: 2
                    },
                    1024: {
                        slidesPerView: 3
                    }
                },
                on: {
                    init: function () {
                        setEqualHeight();
                        this.autoplay.start();
                        updateCounter(this);
                    },
                    slideChange: function () {
                        updateCounter(this);
                    },
                    resize: function () {
                        setEqualHeight();
                    }
                }
            });

            function setEqualHeight() {
                let maxHeight = 0;
                let slides = document.querySelectorAll('.testimonial__item');

                slides.forEach(function(slide) {
                    slide.style.height = 'auto';
                });

                slides.forEach(function(slide) {
                    if (slide.offsetHeight > maxHeight) {
                        maxHeight = slide.offsetHeight;
                    }
                });

                slides.forEach(function(slide) {
                    slide.style.height = maxHeight + 'px';
                });
            }

            function updateCounter(swiper) {
                var currentIndex = swiper.realIndex + 1;
                var totalSlides = originalSlides;
                document.querySelector('.slider-counter').textContent = currentIndex + ' / ' + totalSlides;
            }

            var sliderElement = document.querySelector('.testimonial-slider');

            sliderElement.addEventListener('mouseenter', function () {
                swiper.autoplay.stop();
            });

            sliderElement.addEventListener('mouseleave', function () {
                swiper.autoplay.start();
            });
            // Navigation buttons
            document.querySelector('.testimonial-owl-prev').addEventListener('click', function () {
                swiper.slidePrev();
            });
            document.querySelector('.testimonial-owl-next').addEventListener('click', function () {
                swiper.slideNext();
            });
            swiper.slideTo(1, false, false);
            // ---- testimonial swiper slider ends


            var app = $(".app-slider")
                .on("initialized.owl.carousel changed.owl.carousel", function (e) {
                    if (!e.namespace) {
                        return;
                    }
                    var carousel = e.relatedTarget;
                    $(".app-counter").text(
                        carousel.relative(carousel.current()) +
                        1 +
                        " / " +
                        carousel.items().length
                    );
                })
                .owlCarousel({
                    items: 1,
                    loop: true,
                    margin: 0,
                    nav: false,
                    mouseDrag: false,
                    touchDrag: false,
                    autoplay: true,
                    autoplayTimeout: 2500,
                    autoplayHoverPause: false,
                    rtl: siteDirection,
                    speed: 1000,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000,
                    fluidSpeed: 1000,
                });
            $(".app-content, .app-thumb").on('mouseenter', function() {
                app.trigger("stop.owl.autoplay");
            });
            $(".app-content, .app-thumb").on('mouseleave', function() {
                app.trigger("play.owl.autoplay", [2500]);
            });
            $(".app-owl-prev").on("click", function () {
                app.trigger("prev.owl.carousel");
                $(".owl-stage").css("transition", "all 0.3s ease 1s !important");
            });
            $(".app-owl-next").on("click", function () {
                app.trigger("next.owl.carousel");
            });

            let owl = $(".service-slider").owlCarousel({
                margin: 0,
                responsiveClass: true,
                nav: false,
                dots: false,
                loop: true,
                rtl: siteDirection,
                autoplay: true,
                autoplayTimeout: 2500,
                smartSpeed: 1000,
                autoplayHoverPause: false,
                mouseDrag: true,
                touchDrag: true,
                responsive: {
                    0: {
                        items: 1,
                    },
                    500: {
                        items: 2,
                    },
                    768: {
                        items: 3,
                    },
                    992: {
                        items: 3,
                    },
                    1200: {
                        items: 4,
                    },
                },
            });

            $(".service-section").on('mouseenter', function() {
                owl.trigger("stop.owl.autoplay");
            });
            $(".service-section").on('mouseleave', function() {
                owl.trigger("play.owl.autoplay", [2500]);
            });

            /*Slider Trigger*/
            $(".service-slide-prev").on("click", function () {
                owl.trigger("prev.owl.carousel");
            });
            $(".service-slide-next").on("click", function () {
                owl.trigger("next.owl.carousel");
            });

            $(".service-inner-slider").owlCarousel({
                loop: false,
                margin: 0,
                responsiveClass: true,
                nav: false,
                dots: false,
                autoplay: true,
                rtl: siteDirection,
                autoplayTimeout: 1500,
                autoplayHoverPause: true,
                responsive: {
                    0: {
                        items: 3,
                        margin: 10,
                    },
                    500: {
                        items: 4,
                        margin: 10,
                    },
                    576: {
                        items: 3,
                        margin: 10,
                    },
                    768: {
                        items: 5,
                        margin: 20,
                    },
                    992: {
                        items: 6,
                        margin: 30,
                    },
                    1200: {
                        items: 6,
                        margin: 40,
                    },
                },
            });
            $("[data-target]").on("click", function () {
                const slide = $(this).data("target");
                $(".service__item-popup").each(function () {
                    if ($(this).data("slide") === slide) {
                        $(this).addClass("active");
                    } else {
                        $(this).removeClass("active");
                    }
                });
            });
            $(".close__popup").on("click", function () {
                $(".service__item-popup").removeClass("active");
            });
        });
    })(jQuery);
</script>

<script>
    // ---- service section active starts
    $(document).ready(function () {
        var $homeMenu = $('a[href="<?php echo e(route('home')); ?>"]');
        var $serviceMenu = $('a[href="<?php echo e(route('home')); ?>#service"]');
        var $serviceSection = $('.service-section');
        var $bannerSection = $('.banner-section');

        function checkSections() {
            var bannerHeight = $bannerSection.outerHeight();
            var serviceTop = $serviceSection.offset().top - 100;
            var serviceBottom = serviceTop + $serviceSection.outerHeight();
            var scrollTop = $(window).scrollTop();
            var scrollBottom = scrollTop + $(window).height();

            // Home menu active when above service section
            if (scrollTop + bannerHeight < serviceTop) {
                $homeMenu.addClass('active');
                $serviceMenu.removeClass('active');
            }
            // Service menu active when in service section
            else if (scrollTop >= serviceTop && scrollTop < serviceBottom) {
                $homeMenu.removeClass('active');
                $serviceMenu.addClass('active');
            }
            // When past all sections, reset to home active
            else {
                $homeMenu.addClass('active');
                $serviceMenu.removeClass('active');
            }
        }

        $(window).on('scroll', checkSections);
        checkSections();

        if (window.location.pathname !== '/') {
            return;
        }
    });
    // ---- service section active end
</script>

</body>
</html>
<?php /**PATH /opt/lampp/htdocs/Demandium-Admin/resources/views/layouts/landing/app.blade.php ENDPATH**/ ?>